/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.editor.FmtFieldTriad;
import com.quantumdata.fmteditor.editor.FmtFieldTriadSpec;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmt.Format;

public class FmtRateTriad
extends FmtFieldTriad {
    public static final int PRAT_ID = 0;
    public static final int HRAT_ID = 1;
    public static final int VRAT_ID = 2;
    public static final int PRATNS_ID = 3;
    public static final int HRAT0_ID = 4;
    public static final int TUNE_ID = 5;
    private CmdValue m_scan;
    private CmdValue m_htot;
    private CmdValue m_vtot;
    protected boolean m_changing = false;
    private boolean m_timeUnits = false;

    public FmtRateTriad(FmtFieldTriadSpec fmtFieldTriadSpec, Format format, int n) {
        super(fmtFieldTriadSpec);
        this.m_scan = format.getValue("SCAN");
        this.m_htot = format.getValue("HTOT");
        this.m_vtot = format.getValue("VTOT");
        this.init(n);
        RateListener rateListener = new RateListener();
        this.m_scan.addListener(rateListener);
        this.m_htot.addListener(rateListener);
        this.m_vtot.addListener(rateListener);
        this.getValue(4).addListener(new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                FmtRateTriad.this.baseChanged();
            }
        });
        this.getValue(5).addListener(new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                FmtRateTriad.this.tuneChanged();
            }
        });
        this.baseChanged();
    }

    protected void valueChanged(int n) {
        if (this.m_changing || !this.isSelected(n)) {
            return;
        }
        this.m_changing = true;
        CmdValue cmdValue = this.getValue(0);
        CmdValue cmdValue2 = this.getValue(1);
        CmdValue cmdValue3 = this.getValue(2);
        CmdValue cmdValue4 = this.getValue(3);
        CmdValue cmdValue5 = this.getValue(5);
        CmdValue cmdValue6 = this.getValue(4);
        double d = this.m_htot.getDouble();
        double d2 = this.m_vtot.getDouble();
        double d3 = this.m_scan.getDouble();
        switch (this.getSelectedId()) {
            case 0: {
                double d4;
                if (!this.m_timeUnits) {
                    d4 = cmdValue.getDouble();
                    if (d4 < 1000000.0) {
                        d4 = 1000000.0;
                        cmdValue.setDouble(d4);
                    }
                } else {
                    d4 = cmdValue4.getDouble();
                    if (d4 < 1.0E-9) {
                        d4 = 1.0E-9;
                        cmdValue.setDouble(d4);
                    }
                    d4 = 1.0 / d4;
                }
                double d5 = d4 / d;
                cmdValue2.setDouble(d5);
                cmdValue6.setDouble(cmdValue5.getDouble() * d5);
                cmdValue3.setDouble(d5 / d2 * d3);
                break;
            }
            case 1: {
                double d6 = cmdValue2.getDouble();
                if (d6 < 1.0) {
                    d6 = 1.0;
                    cmdValue2.setDouble(d6);
                }
                cmdValue.setDouble(d6 * d);
                cmdValue3.setDouble(d6 / d2 * d3);
                cmdValue5.setDouble(cmdValue6.getDouble() / d6);
                break;
            }
            case 2: {
                double d7 = cmdValue3.getDouble();
                if (d7 < 0.1) {
                    d7 = 0.1;
                    cmdValue3.setDouble(d7);
                }
                double d8 = d7 * d2 / d3;
                cmdValue.setDouble(d8 * d);
                cmdValue2.setDouble(d8);
                cmdValue6.setDouble(cmdValue5.getDouble() * d8);
            }
        }
        this.m_changing = false;
    }

    private void tuneChanged() {
        if (this.m_changing) {
            return;
        }
        this.m_changing = true;
        CmdValue cmdValue = this.getValue(5);
        CmdValue cmdValue2 = this.getValue(1);
        CmdValue cmdValue3 = this.getValue(4);
        double d = cmdValue.getDouble();
        if (d <= 0.0) {
            d = 1.0;
            cmdValue.setDouble(d);
        }
        cmdValue2.setDouble(d * cmdValue3.getDouble());
        this.m_changing = false;
    }

    private void baseChanged() {
        if (this.m_changing) {
            return;
        }
        this.m_changing = true;
        CmdValue cmdValue = this.getValue(5);
        CmdValue cmdValue2 = this.getValue(1);
        CmdValue cmdValue3 = this.getValue(4);
        double d = cmdValue3.getDouble();
        if (d <= 1.0) {
            d = cmdValue2.getDouble();
            cmdValue3.setDouble(d);
        }
        cmdValue.setDouble(d / cmdValue2.getDouble());
        this.m_changing = false;
    }

    protected void select(int n) {
        super.select(n);
        boolean bl = this.m_spec.mode == 1;
        this.m_spec.fields[4].setEditable(n == 1 ? bl : !bl);
        this.m_spec.fields[4].setBackground(n == 1 ? this.m_selColor : this.m_notSelColor);
        this.m_spec.fields[4].setFocusable(n == 1 ? bl : !bl);
        this.m_spec.fields[5].setEditable(n == 1 ? bl : !bl);
        this.m_spec.fields[5].setBackground(n == 1 ? this.m_selColor : this.m_notSelColor);
        this.m_spec.fields[5].setFocusable(n == 1 ? bl : !bl);
    }

    protected void update() {
        this.valueChanged(this.getSelectedId());
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.m_timeUnits = !bl;
        if (bl) {
            super.setEnabled(bl);
        }
    }

    private class RateListener
    implements CmdValueListener {
        private RateListener() {
        }

        public void valueChanged(CmdValue cmdValue) {
            FmtRateTriad.this.update();
        }
    }
}

